<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\AbsensiModel;
use App\Models\KelasModel;

class Koreksi extends BaseController
{
    public function index()
    {
        $kelasModel = new KelasModel();
        $data = [
            'title' => 'Koreksi Kehadiran',
            'kelas' => $kelasModel->findAll(),
            'tampil_data' => false,
            'active_tab' => 'guru'
        ];
        return view('admin/koreksi/index', $data);
    }

    public function filter()
    {
        $absensiModel = new AbsensiModel();
        $kelasModel = new KelasModel();

        $userType = $this->request->getGet('user_type');
        $tglAwal = $this->request->getGet('tgl_awal');
        $tglAkhir = $this->request->getGet('tgl_akhir');
        $kelasId = $this->request->getGet('kelas_id');

        $dataLaporan = [];
        if ($userType && $tglAwal && $tglAkhir) {
            $dataLaporan = $absensiModel->getKoreksiData($tglAwal, $tglAkhir, $userType, $kelasId);
        }

        $data = [
            'title' => 'Koreksi Kehadiran',
            'kelas' => $kelasModel->findAll(),
            'tampil_data' => true,
            'absensi' => $dataLaporan,
            'p_type' => $userType,
            'p_awal' => $tglAwal,
            'p_akhir' => $tglAkhir,
            'p_kelas' => $kelasId,
            'active_tab' => $userType
        ];

        return view('admin/koreksi/index', $data);
    }
}