<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\LiburNasionalModel;

class LiburNasional extends BaseController
{
    protected $liburModel;

    public function __construct()
    {
        $this->liburModel = new LiburNasionalModel();
    }

    public function index()
    {
        $data = [
            'title' => 'Hari Libur Nasional',
            'libur' => $this->liburModel->orderBy('tanggal_mulai', 'DESC')->findAll(),
            'validation' => \Config\Services::validation()
        ];
        return view('admin/libur_nasional/index', $data);
    }

    public function new()
    {
        $data = [
            'title' => 'Tambah Hari Libur',
            'validation' => \Config\Services::validation()
        ];
        return view('admin/libur_nasional/form', $data);
    }

    public function create()
    {
        if (!$this->validate([
            'nama_libur' => 'required',
            'tanggal_mulai' => 'required|valid_date',
            'tanggal_akhir' => 'required|valid_date',
        ])) {
            return redirect()->back()->withInput();
        }

        $tglMulai = $this->request->getPost('tanggal_mulai');
        $tglAkhir = $this->request->getPost('tanggal_akhir');

        // Validasi Logika Tanggal
        if ($tglAkhir < $tglMulai) {
            return redirect()->back()->withInput()->with('error', 'Tanggal akhir tidak boleh lebih kecil dari tanggal mulai.');
        }

        $this->liburModel->save([
            'nama_libur' => $this->request->getPost('nama_libur'),
            'tanggal_mulai' => $tglMulai,
            'tanggal_akhir' => $tglAkhir,
            'deskripsi' => $this->request->getPost('deskripsi')
        ]);

        return redirect()->to('/admin/libur-nasional')->with('success', 'Hari libur berhasil ditambahkan.');
    }

    public function delete($id)
    {
        $this->liburModel->delete($id);
        return redirect()->to('/admin/libur-nasional')->with('success', 'Hari libur berhasil dihapus.');
    }
}