<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\SettingHariModel;

class SettingPrint extends BaseController
{
    public function index()
    {
        $model = new SettingHariModel();
        $data = [
            'title' => 'Setting Print Laporan',
            'hari' => $model->findAll()
        ];
        return view('admin/setting_print/index', $data);
    }

    public function save()
    {
        $model = new SettingHariModel();
        $allHari = $model->findAll();
        $checkedIds = $this->request->getPost('hari_id');

        if (!$checkedIds) {
            $checkedIds = [];
        }

        foreach ($allHari as $h) {
            $status = in_array($h['id'], $checkedIds) ? 1 : 0;
            $model->update($h['id'], ['tampilkan' => $status]);
        }

        return redirect()->to('/admin/setting-print')->with('success', 'Pengaturan hari laporan berhasil disimpan.');
    }
}