<?php

namespace App\Controllers\Petugas;

use App\Controllers\BaseController;

class DataAbsensi extends BaseController
{
    public function index()
    {
        $db = \Config\Database::connect();
        
        $builder = $db->table('absensi');
        $builder->select('absensi.*, guru.nama_guru as nama, guru.jabatan as info_tambahan');
        $builder->join('guru', 'guru.id = absensi.user_id');
        $builder->where('absensi.user_type', 'guru');
        $queryGuru = $builder->getCompiledSelect();

        $builder->resetQuery();
        
        $builder->select('absensi.*, siswa.nama_lengkap as nama, kelas.nama_kelas as info_tambahan');
        $builder->join('siswa', 'siswa.id = absensi.user_id');
        $builder->join('kelas', 'kelas.id = siswa.kelas_id');
        $builder->where('absensi.user_type', 'siswa');
        $querySiswa = $builder->getCompiledSelect();

        $query = $db->query("$queryGuru UNION $querySiswa ORDER BY tanggal DESC, jam_masuk DESC");
        $results = $query->getResultArray();

        $data = [
            'title' => 'Data Riwayat Absensi',
            'absensi' => $results
        ];

        return view('petugas/data_absensi', $data);
    }
}