<?= $this->extend('layout/template') ?>

<?= $this->section('content') ?>
<style>
    .card-menu {
        border: none;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.05);
        background: #fff;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        overflow: hidden;
    }

    .card-header-menu {
        padding: 20px;
        color: white;
        font-weight: 700;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .header-blue { background: linear-gradient(135deg, #435ebe 0%, #25396f 100%); }
    .header-green { background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); }

    .nav-pills .nav-link {
        border-radius: 50px;
        padding: 12px 30px;
        font-weight: 600;
        color: #607080;
        background: #fff;
        border: 2px solid #eef2f7;
        margin-right: 10px;
        transition: all 0.3s;
    }

    .nav-pills .nav-link.active {
        background: #435ebe;
        color: #fff;
        border-color: #435ebe;
        box-shadow: 0 5px 15px rgba(67, 94, 190, 0.3);
    }

    .form-control, .form-select {
        border-radius: 10px;
        padding: 10px 15px;
        border: 1px solid #eef2f7;
        background-color: #fcfcfc;
    }

    .form-control:focus, .form-select:focus {
        border-color: #435ebe;
        box-shadow: 0 0 0 4px rgba(67, 94, 190, 0.1);
    }

    .btn-filter {
        border-radius: 10px;
        padding: 12px;
        font-weight: 600;
        width: 100%;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border: none;
        transition: all 0.3s;
        margin-top: 10px;
    }

    .table-modern {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0 10px; 
    }
    .table-modern thead th {
        background-color: #f8f9fa;
        color: #607080;
        font-weight: 700;
        padding: 15px;
        border: none;
    }
    .table-modern tbody tr {
        background-color: #fff;
        box-shadow: 0 2px 10px rgba(0,0,0,0.02);
        transition: transform 0.2s;
    }
    .table-modern tbody tr:hover {
        transform: scale(1.01);
        z-index: 10;
        position: relative;
    }
    .table-modern td {
        padding: 15px;
        vertical-align: middle;
        border: none;
    }
    .table-modern td:first-child {
        border-top-left-radius: 10px;
        border-bottom-left-radius: 10px;
    }
    .table-modern td:last-child {
        border-top-right-radius: 10px;
        border-bottom-right-radius: 10px;
    }
    .status-badge {
        padding: 5px 12px;
        border-radius: 20px;
        font-size: 0.8rem;
        font-weight: 700;
        text-transform: uppercase;
    }
    .status-hadir { background: #d1e7dd; color: #198754; }
    .status-terlambat { background: #f8d7da; color: #dc3545; }
    .status-sakit { background: #cff4fc; color: #0dcaf0; }
    .status-izin { background: #fff3cd; color: #ffc107; }
    .status-alfa { background: #e2e3e5; color: #383d41; }
    .status-cepat-pulang { background: #fff3cd; color: #d39e00; }
</style>

<div class="page-heading mb-4">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h3 class="mb-1 text-primary fw-bold">Koreksi Kehadiran</h3>
            <p class="text-subtitle text-muted">Cari dan perbaiki data absensi jika ada kesalahan.</p>
        </div>
    </div>
</div>

<div class="page-content">
    <?php if (session()->getFlashdata('success')) : ?>
        <div class="alert alert-success alert-dismissible fade show shadow-sm border-0 mb-4" role="alert">
            <i class="bi bi-check-circle-fill me-2"></i> <?= session()->getFlashdata('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <!-- TABS NAVIGASI -->
    <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link <?= (!isset($active_tab) || $active_tab == 'guru') ? 'active' : '' ?>" id="pills-guru-tab" data-bs-toggle="pill" data-bs-target="#pills-guru" type="button">
                <i class="bi bi-person-video3 me-2"></i> Koreksi Guru
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link <?= (isset($active_tab) && $active_tab == 'siswa') ? 'active' : '' ?>" id="pills-siswa-tab" data-bs-toggle="pill" data-bs-target="#pills-siswa" type="button">
                <i class="bi bi-people-fill me-2"></i> Koreksi Siswa
            </button>
        </li>
    </ul>

    <div class="tab-content" id="pills-tabContent">
        
        <!-- === TAB GURU === -->
        <div class="tab-pane fade <?= (!isset($active_tab) || $active_tab == 'guru') ? 'show active' : '' ?>" id="pills-guru" role="tabpanel">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card card-menu">
                        <div class="card-header-menu header-blue">
                            <i class="bi bi-search fs-4"></i> Filter Data Guru
                        </div>
                        <div class="card-body p-4">
                            <form action="<?= base_url('admin/koreksi/filter') ?>" method="get">
                                <input type="hidden" name="user_type" value="guru">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label fw-bold">Tanggal Awal</label>
                                        <input type="date" name="tgl_awal" class="form-control" required value="<?= isset($p_awal) ? $p_awal : date('Y-m-d') ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label fw-bold">Tanggal Akhir</label>
                                        <input type="date" name="tgl_akhir" class="form-control" required value="<?= isset($p_akhir) ? $p_akhir : date('Y-m-d') ?>">
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary btn-filter shadow-sm" style="background: #435ebe; border-color: #435ebe;">
                                    <i class="bi bi-search me-2"></i> Tampilkan Data
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- === TAB SISWA === -->
        <div class="tab-pane fade <?= (isset($active_tab) && $active_tab == 'siswa') ? 'show active' : '' ?>" id="pills-siswa" role="tabpanel">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card card-menu">
                        <div class="card-header-menu header-green">
                            <i class="bi bi-search fs-4"></i> Filter Data Siswa
                        </div>
                        <div class="card-body p-4">
                            <form action="<?= base_url('admin/koreksi/filter') ?>" method="get">
                                <input type="hidden" name="user_type" value="siswa">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Pilih Kelas</label>
                                    <select name="kelas_id" class="form-select" required>
                                        <option value="">-- Pilih Kelas --</option>
                                        <?php foreach($kelas as $k): ?>
                                            <option value="<?= $k['id'] ?>" <?= (isset($p_kelas) && $p_kelas == $k['id']) ? 'selected' : '' ?>>
                                                <?= $k['nama_kelas'] ?> - <?= $k['jurusan'] ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label fw-bold">Tanggal Awal</label>
                                        <input type="date" name="tgl_awal" class="form-control" required value="<?= isset($p_awal) ? $p_awal : date('Y-m-d') ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label fw-bold">Tanggal Akhir</label>
                                        <input type="date" name="tgl_akhir" class="form-control" required value="<?= isset($p_akhir) ? $p_akhir : date('Y-m-d') ?>">
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-success btn-filter shadow-sm" style="background: #11998e; border-color: #11998e;">
                                    <i class="bi bi-search me-2"></i> Tampilkan Data
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- HASIL PENCARIAN -->
    <?php if ($tampil_data): ?>
    <div class="row mt-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm" style="border-radius: 20px;">
                <div class="card-header bg-white pt-4 pb-0 border-0" style="border-radius: 20px 20px 0 0;">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="fw-bold mb-0 text-dark">
                            <i class="bi bi-table me-2 text-primary"></i> 
                            Hasil Pencarian: <?= ucfirst($p_type) ?>
                        </h5>
                        <span class="badge bg-light text-muted">
                            Total: <?= count($absensi) ?> Data
                        </span>
                    </div>
                </div>
                <div class="card-body p-4">
                    <?php if(empty($absensi)): ?>
                        <div class="text-center py-5">
                            <img src="<?= base_url('assets/compiled/svg/no-data.svg') ?>" alt="No Data" style="height: 150px; opacity: 0.5;">
                            <p class="text-muted mt-3">Tidak ada data absensi ditemukan pada kriteria ini.</p>
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-modern">
                                <thead>
                                    <tr>
                                        <th>Tanggal</th>
                                        <th>Nama Lengkap</th>
                                        <th>Jam Masuk</th>
                                        <th>Jam Pulang</th>
                                        <th>Status</th>
                                        <th>Keterangan</th>
                                        <th class="text-center">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($absensi as $row): ?>
                                    <tr>
                                        <td>
                                            <span class="fw-bold text-dark"><?= date('d/m/Y', strtotime($row['tanggal'])) ?></span>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar avatar-sm bg-light-primary me-3 text-primary fw-bold">
                                                    <?= substr($row['nama_lengkap'], 0, 1) ?>
                                                </div>
                                                <div>
                                                    <h6 class="mb-0 text-dark" style="font-size: 0.9rem;"><?= $row['nama_lengkap'] ?></h6>
                                                    <small class="text-muted" style="font-size: 0.75rem;"><?= $row['nomor_induk'] ?></small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <?php if($row['jam_masuk'] && $row['jam_masuk'] != '-'): ?>
                                                <span class="badge bg-light text-success border border-success border-opacity-25">
                                                    <i class="bi bi-box-arrow-in-right me-1"></i> <?= date('H:i', strtotime($row['jam_masuk'])) ?>
                                                </span>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($row['jam_pulang'] && $row['jam_pulang'] != '-'): ?>
                                                <span class="badge bg-light text-primary border border-primary border-opacity-25">
                                                    <i class="bi bi-box-arrow-left me-1"></i> <?= date('H:i', strtotime($row['jam_pulang'])) ?>
                                                </span>
                                            <?php else: ?>
                                                <span class="text-muted small fst-italic">Belum Pulang</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php 
                                                $statusClass = 'status-' . strtolower(str_replace(' ', '-', $row['status']));
                                            ?>
                                            <span class="status-badge <?= $statusClass ?>">
                                                <?= strtoupper($row['status']) ?>
                                            </span>
                                        </td>
                                        <td>
                                            <small class="text-muted text-wrap" style="max-width: 150px; display: block;">
                                                <?php 
                                                    $ket = esc($row['keterangan']);
                                                    if (strpos($ket, 'Cepat Pulang') !== false || strpos($ket, 'Terlambat') !== false) {
                                                        echo '<span class="text-danger fw-bold">' . $ket . '</span>';
                                                    } else {
                                                        echo $ket ? $ket : '-';
                                                    }
                                                ?>
                                            </small>
                                        </td>
                                        <td class="text-center">
                                            <?php if($row['id']): ?>
                                                <a href="<?= base_url('admin/absensi/edit/' . $row['id']) ?>" class="btn btn-warning btn-sm shadow-sm" style="border-radius: 8px;" title="Edit Absensi">
                                                    <i class="bi bi-pencil-square"></i>
                                                </a>
                                            <?php else: ?>
                                                <a href="<?= base_url('admin/absensi/input') . '?user_id='.$row['user_id'].'&user_type='.$row['user_type'].'&tanggal='.$row['tanggal'] ?>" class="btn btn-primary btn-sm shadow-sm" style="border-radius: 8px;" title="Input Kehadiran (Alfa)">
                                                    <i class="bi bi-plus-lg"></i>
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?= $this->endSection() ?>