<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\SoalModel;
use App\Models\KelasModel;

class BankSoal extends BaseController
{
    protected $soalModel;
    protected $kelasModel;
    protected $db;

    public function __construct()
    {
        $this->soalModel = new SoalModel();
        $this->kelasModel = new KelasModel();
        $this->db = \Config\Database::connect();
    }

    public function index()
    {
        $data = [
            'title' => 'Bank Soal (Admin)',
            'kelas' => $this->kelasModel->findAll()
        ];
        return view('admin/bank_soal/index', $data);
    }

    public function mapel($kelasId)
    {
        $mapel = $this->db->table('kelas_mapel')
            ->select('mapel.*')
            ->join('mapel', 'mapel.id = kelas_mapel.mapel_id')
            ->where('kelas_mapel.kelas_id', $kelasId)
            ->get()->getResultArray();

        $data = [
            'title' => 'Pilih Mapel',
            'mapel' => $mapel,
            'kelas_id' => $kelasId
        ];
        return view('admin/bank_soal/mapel', $data);
    }

    public function list($kelasId, $mapelId)
    {
        $soal = $this->soalModel
            ->where('kelas_id', $kelasId)
            ->where('mapel_id', $mapelId)
            ->orderBy('jenis', 'ASC')
            ->findAll();

        $data = [
            'title' => 'Koreksi Soal',
            'soal' => $soal,
            'kelas_id' => $kelasId,
            'mapel_id' => $mapelId
        ];
        return view('admin/bank_soal/list', $data);
    }

    public function edit($id)
    {
        $soal = $this->soalModel->find($id);
        
        if (!$soal) {
            return redirect()->back()->with('error', 'Soal tidak ditemukan.');
        }

        $data = [
            'title' => 'Edit Soal Guru',
            'soal' => $soal
        ];

        if ($soal['jenis'] == 'pg_kompleks') {
            return view('admin/bank_soal/edit_pg_kompleks', $data);
        } elseif ($soal['jenis'] == 'benar_salah') {
            return view('admin/bank_soal/edit_benar_salah', $data);
        } else {
            return view('admin/bank_soal/edit', $data);
        }
    }

    public function update($id)
    {
        $jenis = $this->request->getPost('jenis');
        
        $data = [
            'pertanyaan' => $this->request->getPost('pertanyaan'),
        ];
        
        if ($jenis == 'pg') {
            $data['opsi_a'] = $this->request->getPost('opsi_a');
            $data['opsi_b'] = $this->request->getPost('opsi_b');
            $data['opsi_c'] = $this->request->getPost('opsi_c');
            $data['opsi_d'] = $this->request->getPost('opsi_d');
            $data['opsi_e'] = $this->request->getPost('opsi_e');
            $data['kunci_jawaban'] = $this->request->getPost('kunci_jawaban');
        } elseif ($jenis == 'pg_kompleks') {
            $data['opsi_a'] = $this->request->getPost('opsi_a');
            $data['opsi_b'] = $this->request->getPost('opsi_b');
            $data['opsi_c'] = $this->request->getPost('opsi_c');
            $data['opsi_d'] = $this->request->getPost('opsi_d');
            $data['opsi_e'] = $this->request->getPost('opsi_e');
            
            $kunci = $this->request->getPost('kunci_jawaban'); 
            $data['kunci_jawaban'] = json_encode($kunci);
        } elseif ($jenis == 'benar_salah') {
            $data['kunci_jawaban'] = $this->request->getPost('kunci_jawaban');
        }

        $this->soalModel->update($id, $data);
        
        $soal = $this->soalModel->find($id);
        return redirect()->to("admin/bank_soal/list/{$soal['kelas_id']}/{$soal['mapel_id']}")->with('success', 'Soal berhasil diperbarui Admin.');
    }

    public function delete($id)
    {
        $this->soalModel->delete($id);
        return redirect()->back()->with('success', 'Soal dihapus oleh Admin.');
    }
}