<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\KelasModel;
use Dompdf\Dompdf;
use Dompdf\Options;

class HasilUjian extends BaseController
{
    protected $db;
    protected $kelasModel;

    public function __construct()
    {
        $this->db = \Config\Database::connect();
        $this->kelasModel = new KelasModel();
    }

    public function index()
    {
        $kelasId = $this->request->getGet('kelas_id');
        $mapelId = $this->request->getGet('mapel_id');
        
        $siswaData = [];
        $jadwalInfo = null;

        if ($kelasId && $mapelId) {
            $jadwal = $this->db->table('jadwal_ujian')
                ->where('kelas_id', $kelasId)
                ->where('mapel_id', $mapelId)
                ->orderBy('id', 'DESC')
                ->get()->getRowArray();

            if ($jadwal) {
                $jadwalInfo = $jadwal;
                
                $allSiswa = $this->db->table('siswa')
                    ->where('kelas_id', $kelasId)
                    ->orderBy('nama_lengkap', 'ASC')
                    ->get()->getResultArray();

                foreach ($allSiswa as $s) {
                    $status = $this->db->table('status_ujian_siswa')
                        ->where('jadwal_id', $jadwal['id'])
                        ->where('siswa_id', $s['id'])
                        ->get()->getRowArray();

                    $siswaData[] = [
                        'nama' => $s['nama_lengkap'],
                        'nisn' => $s['nisn'],
                        'status' => $status ? $status['status'] : 'belum_ujian', 
                        'waktu_mulai' => $status ? $status['waktu_mulai'] : '-',
                        'nilai_akhir' => $status ? $status['nilai_total'] : 0
                    ];
                }
            }
        }

        $kelas = $this->kelasModel->findAll();
        $mapel = $this->db->table('mapel')->get()->getResultArray();

        $data = [
            'title' => 'Monitoring & Hasil Ujian',
            'kelas' => $kelas,
            'mapel' => $mapel,
            'siswa_data' => $siswaData,
            'jadwal_info' => $jadwalInfo,
            'selected_kelas' => $kelasId,
            'selected_mapel' => $mapelId
        ];

        return view('admin/hasil_ujian/index', $data);
    }

    public function cetak($kelasId, $mapelId)
    {
        $jadwal = $this->db->table('jadwal_ujian')
            ->select('jadwal_ujian.*, kelas.nama_kelas, mapel.nama_mapel, guru.nama_lengkap as nama_guru, guru.nip')
            ->join('kelas', 'kelas.id = jadwal_ujian.kelas_id')
            ->join('mapel', 'mapel.id = jadwal_ujian.mapel_id')
            ->join('guru', 'guru.id = jadwal_ujian.guru_id', 'left') 
            ->where('jadwal_ujian.kelas_id', $kelasId)
            ->where('jadwal_ujian.mapel_id', $mapelId)
            ->orderBy('id', 'DESC')
            ->get()->getRowArray();

        if (!$jadwal) {
            return redirect()->back()->with('error', 'Data ujian tidak ditemukan untuk dicetak.');
        }

        $sekolah = $this->db->table('sekolah')->where('id', 1)->get()->getRowArray();

        $siswaData = [];
        $allSiswa = $this->db->table('siswa')
            ->where('kelas_id', $kelasId)
            ->orderBy('nama_lengkap', 'ASC')
            ->get()->getResultArray();

        foreach ($allSiswa as $s) {
            $status = $this->db->table('status_ujian_siswa')
                ->where('jadwal_id', $jadwal['id'])
                ->where('siswa_id', $s['id'])
                ->get()->getRowArray();

            $siswaData[] = [
                'nama' => $s['nama_lengkap'],
                'nisn' => $s['nisn'],
                'status' => $status ? $status['status'] : 'belum_ujian',
                'nilai_pg' => $status ? $status['nilai_pg'] : 0,
                'nilai_esai' => $status ? $status['nilai_esai'] : 0,
                'nilai_akhir' => $status ? $status['nilai_total'] : 0
            ];
        }

        $data = [
            'sekolah' => $sekolah,
            'jadwal' => $jadwal,
            'siswa' => $siswaData
        ];

        $options = new Options();
        $options->set('isRemoteEnabled', true); 
        $options->set('defaultFont', 'Arial');

        $dompdf = new Dompdf($options);
        
        $html = view('admin/hasil_ujian/cetak_pdf', $data);
        
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();

        $filename = 'Hasil_Ujian_' . str_replace(' ', '_', $jadwal['nama_mapel']) . '_' . str_replace(' ', '_', $jadwal['nama_kelas']);
        
        $dompdf->stream($filename, ["Attachment" => false]);
        exit();
    }
}